<title>Clicks - History</title>

@extends('user.layouts.master')
@section('css')
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
<link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css?v=1.1.0" type="text/css">
<link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">
<link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/bttn.css" type="text/css">
@endsection

<style>
    /* Overlay Styling */
    .overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        /*background: rgba(0, 0, 0, 0.7);*/
        background: red;
        color: white;
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 1000;
        display: none; /* Hidden by default */
    }

    .overlay.active {
        display: flex; /* Show overlay when 'active' class is added */
    }

    /* Centering content inside the overlay */
    .overlay-content {
        max-width: 600px; /* Max width for the content */
        width: 90%; /* Responsive width */
        padding: 20px;
        box-sizing: border-box;
        background: rgba(0, 0, 0, 0.8); /* Slightly darker background for the content box */
        border-radius: 10px;
        text-align: center;
    }

    /* Text styling */
    .overlay-text p {
        font-size: 18px;
        margin-bottom: 20px;
    }

    /* Button styling */
    .overlay-btn a {
        font-size: 16px;
        padding: 10px 20px;
    }

    /* Responsive styles */
    @media (max-width: 768px) {
        .overlay-text p {
            font-size: 14px; /* Smaller text for tablet */
        }

        .overlay-btn a {
            font-size: 14px; /* Smaller button font */
            padding: 12px 20px; /* Adjust button padding */
        }
    }

    @media (max-width: 480px) {
        .overlay-text p {
            font-size: 12px; /* Even smaller text for phones */
        }

        .overlay-btn a {
            font-size: 12px; /* Even smaller button font */
            padding: 10px 15px; /* Smaller button padding */
        }
    }
</style>


@section('user-content')
<section>
    <div class="card mt-3 p-3">
        <div class="card-header text-center" style="background-color: #f8f9fa; border-bottom: 2px solid #2ECC71;">
           <h3 class="card-title d-flex align-items-center justify-content-center" style="color: #2ECC71; font-size: 24px;">
                <a href="{{ url()->previous() }}" class="btn btn-outline-success btn-sm me-2" title="Go Back">
                    <i class="fas fa-arrow-left"></i>
                </a>
                Ads ID: {{ $latest_link }} History
            </h3>

        </div>

        <div class="container my-3">
            <!-- Table Section -->
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Date</th>
                            <th scope="col">User Name</th>
                        </tr>
                    </thead>
                     <tbody>
                        @forelse($data as $sl => $ads)
                            <tr>
                                <td>{{ ++$sl }}</td>
                                <td>{{ $ads->created_at->format('j M y | h:i A') }}</td>
                                <td>{{ $ads->worker_name }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="text-center">No history records found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
@endsection

